/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.world;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.block.Blocks;
import net.jayjay.dangerzone.entity.Entity;
import net.jayjay.dangerzone.phys.AABB;
import net.jayjay.dangerzone.world.IWorldListener;
import net.jayjay.dangerzone.world.chunk.ChunkPos;
import net.jayjay.dangerzone.world.chunk.WorldChunk;
import net.jayjay.dangerzone.world.generate.BiomeType;
import net.jayjay.dangerzone.world.generate.DZ2WorldGenerator;
import net.jayjay.dangerzone.world.generate.WorldGenerator;

public class World {
    public String worldName;
    public long worldSeed;
    public int renderDistance = 16;
    public ArrayList<Entity> entities = new ArrayList();
    public List<WorldGenerator> worldGenerators = new ArrayList<WorldGenerator>();
    private ArrayList<IWorldListener> levelListeners = new ArrayList();
    private static final int TILE_UPDATE_INTERVAL = 400;
    private static final int CHUNK_SIZE = 16;
    private final ConcurrentHashMap<ChunkPos, WorldChunk> loadedChunks = new ConcurrentHashMap();
    private int unprocessed = 0;
    private static final int NUM_THREADS = Math.max(2, Runtime.getRuntime().availableProcessors() - 1);
    private final Set<ChunkPos> pendingLoads = ConcurrentHashMap.newKeySet();
    private final Set<ChunkPos> pendingSaves = ConcurrentHashMap.newKeySet();
    private final ExecutorService tickExecutor = Executors.newFixedThreadPool(NUM_THREADS, r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("World-Tick-Thread");
        return t;
    });
    private final ExecutorService ioExecutor = Executors.newFixedThreadPool(Math.max(2, NUM_THREADS / 2), r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("Chunk-IO-Thread");
        return t;
    });
    private final ThreadLocal<Random> threadRandom = ThreadLocal.withInitial(() -> new Random(System.nanoTime() + Thread.currentThread().getId()));

    public World(String worldName) {
        this.worldName = worldName;
        this.worldSeed = worldName.hashCode();
        this.worldGenerators.add(new DZ2WorldGenerator(this, this.worldSeed, BiomeType.DEFAULT));
        this.loadEntities();
    }

    public WorldChunk getChunk(int chunkX, int chunkY, int chunkZ) {
        WorldChunk existing;
        ChunkPos pos = new ChunkPos(chunkX, chunkY, chunkZ);
        WorldChunk chunk = this.loadedChunks.get(pos);
        if (chunk == null && (existing = this.loadedChunks.putIfAbsent(pos, chunk = this.generateChunk(chunkX, chunkY, chunkZ))) != null) {
            chunk = existing;
        }
        return chunk;
    }

    private WorldChunk generateChunk(int chunkX, int chunkY, int chunkZ) {
        WorldChunk chunk;
        ChunkPos pos = new ChunkPos(chunkX, chunkY, chunkZ);
        if (this.pendingLoads.contains(pos)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
            WorldChunk existing = this.loadedChunks.get(pos);
            if (existing != null) {
                return existing;
            }
        }
        if ((chunk = this.loadChunkSync(chunkX, chunkY, chunkZ)) != null) {
            return chunk;
        }
        chunk = new WorldChunk(chunkX, chunkY, chunkZ);
        for (WorldGenerator worldGen : this.worldGenerators) {
            worldGen.generateChunk(chunk, chunkX, chunkY, chunkZ, this.worldSeed, 16);
        }
        return chunk;
    }

    public void updateLoadedChunks(double playerX, double playerY, double playerZ) {
        int playerChunkX = (int)Math.floor(playerX / 16.0);
        int playerChunkY = (int)Math.floor(playerY / 16.0);
        int playerChunkZ = (int)Math.floor(playerZ / 16.0);
        HashSet<ChunkPos> chunksToKeep = new HashSet<ChunkPos>();
        ArrayList<ChunkPos> chunksToLoad = new ArrayList<ChunkPos>();
        int dx = -this.renderDistance;
        while (dx <= this.renderDistance) {
            int dz = -this.renderDistance;
            while (dz <= this.renderDistance) {
                int dy = -this.renderDistance;
                while (dy <= this.renderDistance) {
                    int chunkX = playerChunkX + dx;
                    int chunkY = playerChunkY + dy;
                    int chunkZ = playerChunkZ + dz;
                    ChunkPos pos = new ChunkPos(chunkX, chunkY, chunkZ);
                    chunksToKeep.add(pos);
                    if (!this.loadedChunks.containsKey(pos) && !this.pendingLoads.contains(pos)) {
                        chunksToLoad.add(pos);
                    }
                    ++dy;
                }
                ++dz;
            }
            ++dx;
        }
        chunksToLoad.sort((a2, b2) -> {
            int distA = Math.abs(a2.x - playerChunkX) + Math.abs(a2.y - playerChunkY) + Math.abs(a2.z - playerChunkZ);
            int distB = Math.abs(b2.x - playerChunkX) + Math.abs(b2.y - playerChunkY) + Math.abs(b2.z - playerChunkZ);
            return Integer.compare(distA, distB);
        });
        for (ChunkPos pos : chunksToLoad) {
            this.loadChunkAsync(pos.x, pos.y, pos.z);
        }
        ArrayList<Map.Entry<ChunkPos, WorldChunk>> chunksToUnload = new ArrayList<Map.Entry<ChunkPos, WorldChunk>>();
        for (Map.Entry<ChunkPos, WorldChunk> entry : this.loadedChunks.entrySet()) {
            if (chunksToKeep.contains(entry.getKey()) || this.pendingSaves.contains(entry.getKey())) continue;
            chunksToUnload.add(entry);
        }
        for (Map.Entry<ChunkPos, WorldChunk> entry : chunksToUnload) {
            this.saveChunkAsync(entry.getValue(), entry.getKey());
        }
    }

    private void loadChunkAsync(int chunkX, int chunkY, int chunkZ) {
        ChunkPos pos = new ChunkPos(chunkX, chunkY, chunkZ);
        if (!this.pendingLoads.add(pos)) {
            return;
        }
        this.ioExecutor.submit(() -> {
            block7: {
                try {
                    try {
                        WorldChunk chunk = this.loadChunkFromDisk(chunkX, chunkY, chunkZ);
                        if (chunk != null) {
                            this.loadedChunks.putIfAbsent(pos, chunk);
                            break block7;
                        }
                        chunk = new WorldChunk(chunkX, chunkY, chunkZ);
                        for (WorldGenerator worldGen : this.worldGenerators) {
                            worldGen.generateChunk(chunk, chunkX, chunkY, chunkZ, this.worldSeed, 16);
                        }
                        this.loadedChunks.putIfAbsent(pos, chunk);
                    }
                    catch (Exception e2) {
                        System.err.println("Error loading chunk " + pos + ": " + e2.getMessage());
                        e2.printStackTrace();
                        this.pendingLoads.remove(pos);
                    }
                }
                finally {
                    this.pendingLoads.remove(pos);
                }
            }
        });
    }

    private void saveChunkAsync(WorldChunk chunk, ChunkPos pos) {
        if (!this.pendingSaves.add(pos)) {
            return;
        }
        this.ioExecutor.submit(() -> {
            try {
                try {
                    this.saveChunkToDisk(chunk);
                    this.loadedChunks.remove(pos);
                }
                catch (Exception e2) {
                    System.err.println("Error saving chunk " + pos + ": " + e2.getMessage());
                    e2.printStackTrace();
                    this.pendingSaves.remove(pos);
                }
            }
            finally {
                this.pendingSaves.remove(pos);
            }
        });
    }

    private WorldChunk loadChunkSync(int chunkX, int chunkY, int chunkZ) {
        ChunkPos pos = new ChunkPos(chunkX, chunkY, chunkZ);
        this.pendingLoads.add(pos);
        try {
            WorldChunk worldChunk = this.loadChunkFromDisk(chunkX, chunkY, chunkZ);
            return worldChunk;
        }
        finally {
            this.pendingLoads.remove(pos);
        }
    }

    private WorldChunk loadChunkFromDisk(int chunkX, int chunkY, int chunkZ) {
        File chunkFile;
        block5: {
            chunkFile = new File(String.valueOf(this.worldName) + "/" + this.worldName + "_chunks", "chunk_" + chunkX + "_" + chunkY + "_" + chunkZ + ".dat");
            if (chunkFile.exists()) break block5;
            return null;
        }
        try {
            DataInputStream file = new DataInputStream(new GZIPInputStream(new FileInputStream(chunkFile)));
            WorldChunk chunk = new WorldChunk(chunkX, chunkY, chunkZ);
            file.readFully(chunk.blocks);
            int x = 0;
            while (x < 16) {
                int z = 0;
                while (z < 16) {
                    chunk.setLightDepth(x, z, file.readInt());
                    ++z;
                }
                ++x;
            }
            file.close();
            return chunk;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private void saveChunkToDisk(WorldChunk chunk) {
        try {
            File chunkDir = new File(this.worldName, String.valueOf(this.worldName) + "_chunks");
            if (!chunkDir.exists()) {
                chunkDir.mkdirs();
            }
            File chunkFile = new File(chunkDir, "chunk_" + chunk.chunkX + "_" + chunk.chunkY + "_" + chunk.chunkZ + ".dat");
            DataOutputStream file = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(chunkFile)));
            file.write(chunk.blocks);
            int x = 0;
            while (x < 16) {
                int z = 0;
                while (z < 16) {
                    file.writeInt(chunk.getLightDepth(x, z));
                    ++z;
                }
                ++x;
            }
            file.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public int getSurfaceHeight(int x, int y, int z) {
        int chunkX = Math.floorDiv(x, 16);
        int chunkY = Math.floorDiv(y, 16);
        int chunkZ = Math.floorDiv(z, 16);
        WorldChunk chunk = this.getChunk(chunkX, chunkY, chunkZ);
        int localX = Math.floorMod(x, 16);
        int localY = Math.floorMod(y, 16);
        int localZ = Math.floorMod(z, 16);
        int y1 = localY - 1;
        while (y1 >= 0) {
            if (chunk.getBlock(localX, localY, localZ) != 0) {
                return y1;
            }
            --y1;
        }
        return -1;
    }

    public void save() {
        try {
            File worlddir = new File(this.worldName);
            if (!worlddir.exists()) {
                worlddir.mkdirs();
            }
            File file = new File(worlddir, "entities.dat");
            DataOutputStream out = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(file)));
            out.writeInt(this.entities.size());
            for (Entity entity : this.entities) {
                if (entity.removed) continue;
                entity.writeToStream(out);
                entity.writeCustomData(out);
            }
            out.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        ArrayList saveFutures = new ArrayList();
        for (WorldChunk worldChunk : this.loadedChunks.values()) {
            Future<?> future = this.ioExecutor.submit(() -> {
                try {
                    this.saveChunkToDisk(chunk);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            });
            saveFutures.add(future);
        }
        for (Future future : saveFutures) {
            try {
                future.get(30L, TimeUnit.SECONDS);
            }
            catch (Exception e3) {
                System.err.println("Chunk save timeout or error: " + e3.getMessage());
            }
        }
    }

    public void loadEntities() {
        try {
            File entitiesFile = new File(this.worldName, "entities.dat");
            if (!entitiesFile.exists()) {
                return;
            }
            DataInputStream in = new DataInputStream(new GZIPInputStream(new FileInputStream(entitiesFile)));
            int entityCount = in.readInt();
            int i2 = 0;
            while (i2 < entityCount) {
                try {
                    String className = in.readUTF();
                    Class<?> entityClass = Class.forName(className);
                    Entity entity = (Entity)entityClass.getConstructor(World.class).newInstance(this);
                    entity.readFromStream(in);
                    entity.readCustomData(in);
                    this.entities.add(entity);
                }
                catch (Exception e2) {
                    System.err.println("Failed to load entity: " + e2.getMessage());
                    e2.printStackTrace();
                }
                ++i2;
            }
            in.close();
            System.out.println("Loaded " + this.entities.size() + " entities");
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    public void calcLightDepths(int x0, int y0, int z0, int x1, int y1, int z1) {
        int x = x0;
        while (x < x0 + x1) {
            int z = z0;
            while (z < z0 + z1) {
                int chunkX = Math.floorDiv(x, 16);
                int chunkZ = Math.floorDiv(z, 16);
                int localX = Math.floorMod(x, 16);
                int localZ = Math.floorMod(z, 16);
                int lightDepth = Integer.MIN_VALUE;
                block2: for (WorldChunk chunk : this.loadedChunks.values()) {
                    if (chunk.chunkX != chunkX || chunk.chunkZ != chunkZ) continue;
                    int localY = 15;
                    while (localY >= 0) {
                        int worldY = chunk.chunkY * 16 + localY;
                        if (worldY > lightDepth && this.isLightBlocker(x, worldY, z)) {
                            lightDepth = worldY + 1;
                            continue block2;
                        }
                        --localY;
                    }
                }
                if (lightDepth == Integer.MIN_VALUE) {
                    lightDepth = Integer.MIN_VALUE;
                }
                for (WorldChunk chunk : this.loadedChunks.values()) {
                    if (chunk.chunkX != chunkX || chunk.chunkZ != chunkZ) continue;
                    chunk.setLightDepth(localX, localZ, lightDepth);
                }
                ++z;
            }
            ++x;
        }
    }

    public boolean isLightBlocker(int x, int y, int z) {
        Block tile = Blocks.blocks[this.getBlock(x, y, z)];
        return tile == null ? false : tile.blocksLight();
    }

    public ArrayList<AABB> getCubes(AABB aABB) {
        ArrayList<AABB> aABBs = new ArrayList<AABB>();
        int x0 = (int)Math.floor(aABB.x0);
        int x1 = (int)Math.floor(aABB.x1 + 1.0f);
        int y0 = (int)Math.floor(aABB.y0);
        int y1 = (int)Math.floor(aABB.y1 + 1.0f);
        int z0 = (int)Math.floor(aABB.z0);
        int z1 = (int)Math.floor(aABB.z1 + 1.0f);
        int x = x0;
        while (x < x1) {
            int y = y0;
            while (y < y1) {
                int z = z0;
                while (z < z1) {
                    AABB aabb;
                    Block tile = Blocks.blocks[this.getBlock(x, y, z)];
                    if (tile != null && (aabb = tile.getAABB(x, y, z)) != null) {
                        aABBs.add(aabb);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return aABBs;
    }

    public boolean setBlock(int x, int y, int z, int type) {
        int localZ;
        int localY;
        int localX;
        int chunkZ;
        int chunkY;
        int chunkX = Math.floorDiv(x, 16);
        WorldChunk chunk = this.getChunk(chunkX, chunkY = Math.floorDiv(y, 16), chunkZ = Math.floorDiv(z, 16));
        if (type == chunk.getBlock(localX = Math.floorMod(x, 16), localY = Math.floorMod(y, 16), localZ = Math.floorMod(z, 16))) {
            return false;
        }
        chunk.setBlock(localX, localY, localZ, type);
        this.calcLightDepths(x, 0, z, 1, 1, 1);
        for (IWorldListener listener : this.levelListeners) {
            listener.tileChanged(x, y, z);
        }
        return true;
    }

    public boolean isLit(int x, int y, int z) {
        int localZ;
        int localX;
        int chunkZ;
        int chunkY;
        int chunkX = Math.floorDiv(x, 16);
        WorldChunk chunk = this.getChunk(chunkX, chunkY = Math.floorDiv(y, 16), chunkZ = Math.floorDiv(z, 16));
        int lightDepth = chunk.getLightDepth(localX = Math.floorMod(x, 16), localZ = Math.floorMod(z, 16));
        if (lightDepth == Integer.MIN_VALUE) {
            return true;
        }
        return y >= lightDepth;
    }

    public int getBlock(int x, int y, int z) {
        int chunkX = Math.floorDiv(x, 16);
        int chunkY = Math.floorDiv(y, 16);
        int chunkZ = Math.floorDiv(z, 16);
        WorldChunk chunk = this.getChunk(chunkX, chunkY, chunkZ);
        int localX = Math.floorMod(x, 16);
        int localY = Math.floorMod(y, 16);
        int localZ = Math.floorMod(z, 16);
        return chunk.getBlock(localX, localY, localZ);
    }

    public boolean isSolidBlock(int x, int y, int z) {
        Block block = Blocks.blocks[this.getBlock(x, y, z)];
        return block == null ? false : block.isSolid();
    }

    public boolean isEntityInBlock(int x, int y, int z) {
        for (Entity entity : this.entities) {
            int entityX = (int)Math.floor(entity.x);
            int entityY = (int)Math.floor(entity.y);
            int entityZ = (int)Math.floor(entity.z);
            if (entityX != x || entityY != y || entityZ != z) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void tick() {
        void var7_8;
        if (this.loadedChunks.isEmpty()) {
            return;
        }
        int totalBlocks = this.loadedChunks.size() * 16 * 16 * 16;
        this.unprocessed += totalBlocks;
        int ticks = this.unprocessed / 400;
        this.unprocessed -= ticks * 400;
        if (ticks == 0) {
            return;
        }
        int ticksPerThread = Math.max(1, ticks / NUM_THREADS);
        WorldChunk[] chunkArray = this.loadedChunks.values().toArray(new WorldChunk[0]);
        int numChunks = chunkArray.length;
        if (numChunks == 0) {
            return;
        }
        ArrayList futures = new ArrayList(NUM_THREADS);
        boolean bl = false;
        while (var7_8 < NUM_THREADS) {
            int threadTicks;
            void threadId = var7_8;
            int n = threadTicks = threadId == NUM_THREADS - 1 ? ticks - ticksPerThread * (NUM_THREADS - 1) : ticksPerThread;
            if (threadTicks > 0) {
                Future<?> future = this.tickExecutor.submit(() -> {
                    Random rand = this.threadRandom.get();
                    int i2 = 0;
                    while (i2 < threadTicks) {
                        Block block;
                        int localZ;
                        int localY;
                        int localX;
                        WorldChunk chunk = chunkArray[rand.nextInt(numChunks)];
                        int blockId = chunk.getBlock(localX = rand.nextInt(16), localY = rand.nextInt(16), localZ = rand.nextInt(16));
                        if (blockId != 0 && (block = Blocks.blocks[blockId]) != null) {
                            int worldX = chunk.chunkX * 16 + localX;
                            int worldY = chunk.chunkY * 16 + localY;
                            int worldZ = chunk.chunkZ * 16 + localZ;
                            block.tick(this, worldX, worldY, worldZ, rand);
                        }
                        ++i2;
                    }
                });
                futures.add(future);
            }
            ++var7_8;
        }
        for (Future future : futures) {
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e2) {
                future.cancel(true);
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
    }

    public Collection<WorldChunk> getLoadedChunks() {
        return this.loadedChunks.values();
    }

    public void addListener(IWorldListener levelListener) {
        this.levelListeners.add(levelListener);
    }

    public void removeListener(IWorldListener levelListener) {
        this.levelListeners.remove(levelListener);
    }

    public void setRenderDistance(int distance) {
        this.renderDistance = distance;
    }

    public int getRenderDistance() {
        return this.renderDistance;
    }

    public void shutdown() {
        this.save();
        this.ioExecutor.shutdown();
        try {
            if (!this.ioExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                System.err.println("forcing shutdown");
                this.ioExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e2) {
            this.ioExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.tickExecutor.shutdown();
        try {
            if (!this.tickExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.tickExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e3) {
            this.tickExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

